<div class="rule-set">
    <div class="rule-set">
        <div class="action-buttons">
            <button class="button button-delete" onclick="deleteRule(this)">
                <?php echo __('Delete Workflow', 'CAI');?>
            </button>
        </div>
        <div class="rules_table">

            <table class="form-table">
                <tr>
                    <th scope="row">
                        <label for="">
                            <?php echo __('Rule name', 'CAI');?>:</label>
                    </th>
                    <td>
                        <input name="frm_rule[<?php echo esc_attr($actIndex);?>]['rule_name']" placeholder="eg On new WP Registration" type="text" class="regular-text" />
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="">
                            <?php echo __('Select Triggers', 'CAI');?>:</label>
                    </th>
                    <td>
                        <select name="frm_rule[<?php echo esc_attr($actIndex);?>]['trigger']" onchange="fetchTriggerOptions(this,'<?php echo esc_attr($actIndex);?>')">
                            <option value="">
                                <?php echo __('Choose a Trigger', 'CAI');?>
                            </option>
                            <?php foreach($triggers as $key=>$trigger): ?>
                                <option value="<?php echo esc_attr($trigger['trigger_slug']);?>" data-trigger-option="<?php echo esc_attr($trigger['no_option']);?>" data-trigger-option-index="<?php echo esc_attr($key);?>">
                                    <?php echo esc_html($trigger['title']);?>
                                </option>
                                <?php endforeach; ?>
                        </select>
                    </td>
                </tr>

                <tr>
                    <th scope="row">
                        <label for="">
                            <?php echo __('Select Action', 'CAI');?>:</label>
                    </th>
                    <td>
                        <select name="frm_rule[<?php echo esc_attr($actIndex);?>]['action']" onchange="fetchActionsOptions(this, '<?php echo esc_attr($actIndex);?>')">
                            <option value="">
                                <?php echo __('Choose a action', 'CAI');?>
                            </option>
                            <?php foreach($actions as $key=>$action): ?>
                                <option value="<?php echo esc_attr($action['action_slug']);?>" data-action-option="<?php echo esc_attr($action['no_option']);?>" data-action-option-index="<?php echo esc_attr($key);?>">
                                    <?php echo esc_html($action['title']);?>
                                </option>
                                <?php endforeach; ?>
                        </select>
                    </td>
                </tr>

            </table>
        </div>
    </div>
